#include "DebugLogger.h"
#include "devpciedefs.h"

#pragma region Constants

const char* EnumNames_EPCIEHostControllerVersion[] =
{
  stringify( PCIE_HOSTCONTROLLERVERSION_MAJOR ),
  stringify( PCIE_HOSTCONTROLLERVERSION_MINOR ),
  stringify( PCIE_HOSTCONTROLLERVERSION_RELEASE ),
  stringify( PCIE_HOSTCONTROLLERVERSION_BUILD ),
};

const char* EnumNames_EPCIEDecProp[] =
{
  stringify( PCIE_DECP_RESOURCE ),
  stringify( PCIE_DECP_DEC ),
  stringify( PCIE_DECP_LOC ),
  stringify( PCIE_DECP_PREFETCHABLE ),
  stringify( PCIE_DECP_QUEUE ),
  stringify( PCIE_DECP_SIZE ),
  stringify( PCIE_DECP_BASEADDR_LO ),
  stringify( PCIE_DECP_BASEADDR_HI ),
  stringify( PCIE_DECP_INTADDR ),
  stringify( PCIE_DECP_INTSIZE ),
};

const char* EnumNames_EPCIECompQueue[] =
{
  stringify( PCIE_COMPQUEUE_0 ),
  stringify( PCIE_COMPQUEUE_1 ),
  stringify( PCIE_COMPQUEUE_2 ),
  stringify( PCIE_COMPQUEUE_3 ),
  stringify( PCIE_COMPQUEUE_4 ),
  stringify( PCIE_COMPQUEUE_END ),
};

const char* EnumNames_EPCIEDec[] =
{
  stringify( PCIE_DEC_BAR0 ),
  stringify( PCIE_DEC_BAR1 ),
  stringify( PCIE_DEC_BAR2 ),
  stringify( PCIE_DEC_BAR3 ),
  stringify( PCIE_DEC_BAR4 ),
  stringify( PCIE_DEC_BAR5 ),
  stringify( PCIE_DEC_EXP ),
  stringify( PCIE_DEC_SUB ),
};

const char* EnumNames_EPCIESiStatus[] =
{
  stringify( PCIE_SISTATUS_COMP_AVAILABLE ),
  stringify( PCIE_SISTATUS_SENT ),
};

const char* EnumNames_EPCIESi[] =
{
  stringify( PCIE_SI_LEN ),
  stringify( PCIE_SI_RSVD023 ),
  stringify( PCIE_SI_ATTR ),
  stringify( PCIE_SI_EP ),
  stringify( PCIE_SI_TD ),
  stringify( PCIE_SI_RSVD013 ),
  stringify( PCIE_SI_TC ),
  stringify( PCIE_SI_RSVD017 ),
  stringify( PCIE_SI_TYPE ),
  stringify( PCIE_SI_FMT ),
  stringify( PCIE_SI_RSVD007 ),
  stringify( PCIE_SI_1STDWBE ),
  stringify( PCIE_SI_LASTDWBE ),
  stringify( PCIE_SI_TAG ),
  stringify( PCIE_SI_REQID ),
  stringify( PCIE_SI_CFG_RSVD111 ),
  stringify( PCIE_SI_CFG_REGNUM ),
  stringify( PCIE_SI_CFG_EXTREGNUM ),
  stringify( PCIE_SI_CFG_RSVD107 ),
  stringify( PCIE_SI_CFG_FUNCNUM ),
  stringify( PCIE_SI_CFG_DEVNUM ),
  stringify( PCIE_SI_CFG_BUSNUM ),
  stringify( PCIE_SI_MEM64_ADDRHI ),
  stringify( PCIE_SI_MEM64_ADDRLO ),
  stringify( PCIE_SI_MEM64_RSVD151 ),
  stringify( PCIE_SI_MEM32_ADDR ),
  stringify( PCIE_SI_MEM32_RSVD111 ),
  stringify( PCIE_SI_MCODE ),
  stringify( PCIE_SI_IO_ADDR ),
  stringify( PCIE_SI_IO_RSVD111 ),
  stringify( PCIE_SI_MSGAS_RSVD047 ),
  stringify( PCIE_SI_MSGAS_RSVD087 ),
  stringify( PCIE_SI_MSGAS_RSVD127 ),
  stringify( PCIE_SI_MSG_BYTES08_11 ),
  stringify( PCIE_SI_MSG_BYTES12_15 ),
  stringify( PCIE_SI_MSGASD_RSVD047 ),
  stringify( PCIE_SI_MSGASD_RSVD087 ),
  stringify( PCIE_SI_MSGASD_RSVD127 ),
  stringify( PCIE_SI_COMP_REQID ),
  stringify( PCIE_SI_COMP_COMPLID ),
  stringify( PCIE_SI_COMP_STATUS ),
  stringify( PCIE_SI_COMP_BYTECOUNT ),
  stringify( PCIE_SI_COMP_BCM ),
  stringify( PCIE_SI_COMP_TAG ),
  stringify( PCIE_SI_COMP_RSVD117 ),
  stringify( PCIE_SI_COMP_LOWERADDR ),
  stringify( PCIE_SI_OBSOLETE_46 ),
  stringify( PCIE_SI_AUTOTAG ),
  stringify( PCIE_SI_RESOURCE ),
  stringify( PCIE_SI_INTADDR ),
  stringify( PCIE_SI_BUSERROR ),
  stringify( PCIE_SI_FUNCTION_SELECTED ),
};

const char* EnumNames_EPCIEHwChannelFunction[] =
{
  stringify( PCIE_HWCHANNEL_FUNCTION_A ),
  stringify( PCIE_HWCHANNEL_FUNCTION_B ),
  stringify( PCIE_HWCHANNEL_FUNCTION_C ),
  stringify( PCIE_HWCHANNEL_FUNCTION_D ),
  stringify( PCIE_HWCHANNEL_FUNCTION_E ),
  stringify( PCIE_HWCHANNEL_FUNCTION_BVF1 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_BVF2 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_CVF1 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_CVF2 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_DVF1 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_DVF2 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_EVF1 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_EVF2 ),
  stringify( PCIE_HWCHANNEL_FUNCTION_END ),
};

const char* EnumNames_EPCIEVCResourceId[] =
{
  stringify( PCIE_VC_RESOURCE_0 ),
  stringify( PCIE_VC_RESOURCE_1 ),
  stringify( PCIE_VC_RESOURCE_2 ),
  stringify( PCIE_VC_RESOURCE_3 ),
  stringify( PCIE_VC_RESOURCE_4 ),
  stringify( PCIE_VL_RESOURCE_0 ),
  stringify( PCIE_VC_RESOURCE_END ),
};

const char* EnumNames_EPCIEVCResourceProp[] =
{
  stringify( PCIE_HWCHANNELP_VCID ),
  stringify( PCIE_HWCHANNELP_VC_ENABLE ),
  stringify( PCIE_HWCHANNELP_OBSOLETE_01 ),
  stringify( PCIE_HWCHANNELP_IGNORE_CLIMIT ),
  stringify( PCIE_HWCHANNELP_INITADV_PH ),
  stringify( PCIE_HWCHANNELP_INITADV_PD ),
  stringify( PCIE_HWCHANNELP_INITADV_NPH ),
  stringify( PCIE_HWCHANNELP_INITADV_NPD ),
  stringify( PCIE_HWCHANNELP_INITADV_CPLH ),
  stringify( PCIE_HWCHANNELP_INITADV_CPLD ),
};

const char* EnumNames_EPCIEVCResourceStatusProp[] =
{
  stringify( PCIE_HWCHANNELSTATUSP_ALLOC_PH ),
  stringify( PCIE_HWCHANNELSTATUSP_ALLOC_PD ),
  stringify( PCIE_HWCHANNELSTATUSP_ALLOC_NPH ),
  stringify( PCIE_HWCHANNELSTATUSP_ALLOC_NPD ),
  stringify( PCIE_HWCHANNELSTATUSP_ALLOC_CPLH ),
  stringify( PCIE_HWCHANNELSTATUSP_ALLOC_CPLD ),
  stringify( PCIE_HWCHANNELSTATUSP_LIMIT_PH ),
  stringify( PCIE_HWCHANNELSTATUSP_LIMIT_PD ),
  stringify( PCIE_HWCHANNELSTATUSP_LIMIT_NPH ),
  stringify( PCIE_HWCHANNELSTATUSP_LIMIT_NPD ),
  stringify( PCIE_HWCHANNELSTATUSP_LIMIT_CPLH ),
  stringify( PCIE_HWCHANNELSTATUSP_LIMIT_CPLD ),
  stringify( PCIE_HWCHANNELSTATUSP_CONS_PH ),
  stringify( PCIE_HWCHANNELSTATUSP_CONS_PD ),
  stringify( PCIE_HWCHANNELSTATUSP_CONS_NPH ),
  stringify( PCIE_HWCHANNELSTATUSP_CONS_NPD ),
  stringify( PCIE_HWCHANNELSTATUSP_CONS_CPLH ),
  stringify( PCIE_HWCHANNELSTATUSP_CONS_CPLD ),
}; 

const char* EnumNames_EPCIEProtRule[] =
{
  stringify( PCIE_PROTRULE_UNSUPPORTED_REQUEST ),
  stringify( PCIE_PROTRULE_DECODER_MISS ),
  stringify( PCIE_PROTRULE_NULLIFIED_LCRC ),
  stringify( PCIE_PROTRULE_BAD_EDB_LCRC ),
  stringify( PCIE_PROTRULE_NAK_SENT ),
  stringify( PCIE_PROTRULE_TLP_SEQUENCE ),
  stringify( PCIE_PROTRULE_INVALID_6 ),
  stringify( PCIE_PROTRULE_DLLP_CRC ),
  stringify( PCIE_PROTRULE_DESKEW_ALIGN ),
  stringify( PCIE_PROTRULE_DISPARITY ),
  stringify( PCIE_PROTRULE_CODING ),
  stringify( PCIE_PROTRULE_128B_130B_SYNC_ERROR ),
  stringify( PCIE_PROTRULE_INVALID_12 ),
  stringify( PCIE_PROTRULE_INVALID_13 ),
  stringify( PCIE_PROTRULE_INVALID_14 ),
  stringify( PCIE_PROTRULE_INVALID_15 ),
  stringify( PCIE_PROTRULE_INVALID_16 ),
  stringify( PCIE_PROTRULE_INVALID_17 ),
  stringify( PCIE_PROTRULE_INVALID_18 ),
  stringify( PCIE_PROTRULE_INVALID_19 ),
  stringify( PCIE_PROTRULE_INVALID_20 ),
  stringify( PCIE_PROTRULE_INVALID_21 ),
  stringify( PCIE_PROTRULE_INVALID_22 ),
  stringify( PCIE_PROTRULE_INVALID_23 ),
  stringify( PCIE_PROTRULE_INVALID_24 ),
  stringify( PCIE_PROTRULE_INVALID_25 ),
  stringify( PCIE_PROTRULE_INVALID_26 ),
  stringify( PCIE_PROTRULE_INVALID_27 ),
  stringify( PCIE_PROTRULE_PCIE_ECRC_ERROR ),
  stringify( PCIE_PROTRULE_END ),
};

const char* EnumNames_EPCIEProtRuleVC[] =
{
  stringify( PCIE_PROTRULE_FC_TIMEOUT ),
  stringify( PCIE_PROTRULE_MRIOV_ECRC_ERROR ),
  stringify( PCIE_PROTRULE_VC_END ),
};

const char* EnumNames_EPCIEProtRuleFunction[] =
{
  stringify( PCIE_PROTRULE_COMPLETION_DATA ),
  stringify( PCIE_PROTRULE_UNEXPECTED_COMPLETION ),
  stringify( PCIE_PROTRULE_COMPLETION_TIMEOUT ),
  stringify( PCIE_PROTRULE_FUNCTION_END ),
};

const char* EnumNames_EPCIEBlock[] =
{
  stringify( PCIE_BLOCK_LEN ),
  stringify( PCIE_BLOCK_RSVD023 ),
  stringify( PCIE_BLOCK_ATTR ),
  stringify( PCIE_BLOCK_RSVD013 ),
  stringify( PCIE_BLOCK_TC ),
  stringify( PCIE_BLOCK_RSVD017 ),
  stringify( PCIE_BLOCK_TYPE ),
  stringify( PCIE_BLOCK_FMT ),
  stringify( PCIE_BLOCK_RSVD007 ),
  stringify( PCIE_BLOCK_1STDWBE ),
  stringify( PCIE_BLOCK_LASTDWBE ),
  stringify( PCIE_BLOCK_CFG_RSVD111 ),
  stringify( PCIE_BLOCK_CFG_REGNUM ),
  stringify( PCIE_BLOCK_CFG_EXTREGNUM ),
  stringify( PCIE_BLOCK_CFG_RSVD107 ),
  stringify( PCIE_BLOCK_CFG_FUNCNUM ),
  stringify( PCIE_BLOCK_CFG_DEVNUM ),
  stringify( PCIE_BLOCK_CFG_BUSNUM ),
  stringify( PCIE_BLOCK_MEM64_ADDRHI ),
  stringify( PCIE_BLOCK_MEM64_ADDRLO ),
  stringify( PCIE_BLOCK_MEM64_RSVD151 ),
  stringify( PCIE_BLOCK_MEM32_ADDR ),
  stringify( PCIE_BLOCK_MEM32_RSVD111 ),
  stringify( PCIE_BLOCK_MCODE ),
  stringify( PCIE_BLOCK_IO_ADDR ),
  stringify( PCIE_BLOCK_IO_RSVD111 ),
  stringify( PCIE_BLOCK_MSGAS_RSVD047 ),
  stringify( PCIE_BLOCK_MSGAS_RSVD087 ),
  stringify( PCIE_BLOCK_MSGAS_RSVD127 ),
  stringify( PCIE_BLOCK_MSG_BYTES08_11 ),
  stringify( PCIE_BLOCK_MSG_BYTES12_15 ),
  stringify( PCIE_BLOCK_MSGASD_RSVD047 ),
  stringify( PCIE_BLOCK_MSGASD_RSVD087 ),
  stringify( PCIE_BLOCK_MSGASD_RSVD127 ),
  stringify( PCIE_BLOCK_OBSOLETE_34 ),
  stringify( PCIE_BLOCK_RESOURCE ),
  stringify( PCIE_BLOCK_REPEAT ),
  stringify( PCIE_BLOCK_PATTERN_TERM ),
  stringify( PCIE_BLOCK_WAITREPEAT ),
  stringify( PCIE_BLOCK_INTADDR ),
  stringify( PCIE_BLOCK_MARK ),
};

const char* EnumNames_EPCIEReqBeh[] =
{
  stringify( PCIE_REQBEH_EP ),
  stringify( PCIE_REQBEH_TD ),
  stringify( PCIE_REQBEH_INCORRECT_LCRC ),
  stringify( PCIE_REQBEH_NULLIFIED_TLP ),
  stringify( PCIE_REQBEH_WRONG_PYLD_SIZE ),
  stringify( PCIE_REQBEH_INSERT_TD ),
  stringify( PCIE_REQBEH_PRIORITY ),
  stringify( PCIE_REQBEH_INCORRECT_ECRC ),
  stringify( PCIE_REQBEH_INCORRECT_DISP ),
  stringify( PCIE_REQBEH_AUTOTAG ),
  stringify( PCIE_REQBEH_TAG ),
  stringify( PCIE_REQBEH_GAP ),
  stringify( PCIE_REQBEH_REPEAT ),
  stringify( PCIE_REQBEH_REPLACE_STP ),
  stringify( PCIE_REQBEH_REPLACE_END ),
  stringify( PCIE_REQBEH_REPLACE_SEQNO ),
  stringify( PCIE_REQBEH_LEN ),
};

const char* EnumNames_EPCIECompBeh[] =
{
  stringify( PCIE_COMPBEH_EP ),
  stringify( PCIE_COMPBEH_TD ),
  stringify( PCIE_COMPBEH_INCORRECT_LCRC ),
  stringify( PCIE_COMPBEH_NULLIFIED_TLP ),
  stringify( PCIE_COMPBEH_WRONG_PYLD_SIZE ),
  stringify( PCIE_COMPBEH_INSERT_TD ),
  stringify( PCIE_COMPBEH_PRIORITY ),
  stringify( PCIE_COMPBEH_INCORRECT_ECRC ),
  stringify( PCIE_COMPBEH_INCORRECT_DISP ),
  stringify( PCIE_COMPBEH_COMPSTATUS ),
  stringify( PCIE_COMPBEH_RCB_COUNT ),
  stringify( PCIE_COMPBEH_OBSOLETE_11 ),
  stringify( PCIE_COMPBEH_OBSOLETE_12 ),
  stringify( PCIE_COMPBEH_OBSOLETE_13 ),
  stringify( PCIE_COMPBEH_REPLACE_STP ),
  stringify( PCIE_COMPBEH_REPLACE_END ),
  stringify( PCIE_COMPBEH_REPLACE_SEQNO ),
  stringify( PCIE_COMPBEH_DISCARD ),
  stringify( PCIE_COMPBEH_REPEAT ),
};

const char* EnumNames_EPCIEDllPhy[] =
{
  stringify( PCIE_DLLPHY_LINKMODE_CAPABLE ),
  stringify( PCIE_DLLPHY_OBSOLETE_01 ),
  stringify( PCIE_DLLPHY_DISABLE_SCRAMBLE ),
  stringify( PCIE_DLLPHY_OBSOLETE_03 ),
  stringify( PCIE_DLLPHY_FC_UPDATE_PERIOD ),
  stringify( PCIE_DLLPHY_RESEND_PERIOD ),
  stringify( PCIE_DLLPHY_TX_POLARITY_INVERSION_MAP ),
  stringify( PCIE_DLLPHY_UPSTREAM_PORT_ENABLE ),
  stringify( PCIE_DLLPHY_SKIP_INTERVAL ),
  stringify( PCIE_DLLPHY_LINKNUMBER_ADVERTISED ),
  stringify( PCIE_DLLPHY_REPLAY_TIMER ),
  stringify( PCIE_DLLPHY_OUTPUT_ENABLE_DELAY ),
  stringify( PCIE_DLLPHY_DUT_CONNECTIVITY ),
  stringify( PCIE_DLLPHY_ENABLE_LANE_REVERSAL ),
  stringify( PCIE_DLLPHY_STP_SYMBOL ),
  stringify( PCIE_DLLPHY_END_SYMBOL ),
  stringify( PCIE_DLLPHY_SEQNO_OFFSET ),
  stringify( PCIE_DLLPHY_DELAY_COMP_QUEUE0 ),
  stringify( PCIE_DLLPHY_DELAY_COMP_QUEUE1 ),
  stringify( PCIE_DLLPHY_DELAY_COMP_QUEUE2 ),
  stringify( PCIE_DLLPHY_DELAY_COMP_QUEUE3 ),
  stringify( PCIE_DLLPHY_CROSSLINK_CAPABLE ),
  stringify( PCIE_DLLPHY_MAX_FTS_GEN1 ),
  stringify( PCIE_DLLPHY_MAX_FTS_GEN2 ),
  stringify( PCIE_DLLPHY_LINKSTATEDIRECT_TIMEOUT ),
  stringify( PCIE_DLLPHY_TS_FORCE_PAD ),
  stringify( PCIE_DLLPHY_L0S_ENTRY_TIMEOUT ),
  stringify( PCIE_DLLPHY_ENABLE_DETECT_LANE_REVERSAL ),
  stringify( PCIE_DLLPHY_SKIP_SYMBOLS_NUM ),
  stringify( PCIE_DLLPHY_FC_TIMEOUT ),
  stringify( PCIE_DLLPHY_DEEMPHASIS_LEVEL_GEN1 ),
  stringify( PCIE_DLLPHY_DEEMPHASIS_LEVEL_GEN2 ),
  stringify( PCIE_DLLPHY_DEEMPHASIS_IN_TS ),
  stringify( PCIE_DLLPHY_FC_UPDATE_PERIOD_ENABLE ),
  stringify( PCIE_DLLPHY_L0S_TIMEOUT_ENABLE ),
  stringify( PCIE_DLLPHY_L0S_EXIT_SKP_OS_ENABLE ),
  stringify( PCIE_DLLPHY_L0S_EXIT_FTS_NUM ),
  stringify( PCIE_DLLPHY_L0S_EXIT_FTS_NUM_ENABLE ),
  stringify( PCIE_DLLPHY_ASPM_L1_ENTRY_TIMEOUT ),
  stringify( PCIE_DLLPHY_L1_EXIT_TIMEOUT ),
  stringify( PCIE_DLLPHY_L1_EXIT_TIMEOUT_ENABLE ),
  stringify( PCIE_DLLPHY_PCIPM_L1_AGRESSIVE ),
  stringify( PCIE_DLLPHY_CROSSLINK_TIMEOUT ),
  stringify( PCIE_DLLPHY_LINK_UPCONFIGURE_IN_TS ),
  stringify( PCIE_DLLPHY_MGT_PROTECTION_ENABLE ),
  stringify( PCIE_DLLPHY_TOPCONNECTOR_ENABLE ),
  stringify( PCIE_DLLPHY_COMPLETION_TIMEOUT ),
  stringify( PCIE_DLLPHY_EIDLE_SENSOR_ENABLE ),
  stringify( PCIE_DLLPHY_PERFORMANCE_MODE ),
  stringify( PCIE_DLLPHY_TX_PRESET_VALUE ),
  stringify( PCIE_DLLPHY_REQUEST_PEER_DEVICE_TO_USE_PRESETS_ENABLE ),
  stringify( PCIE_DLLPHY_TX_PRESET_VALUE_REQUEST_TO_PEER_DEVICE ),
  stringify( PCIE_DLLPHY_REQUEST_PEER_DEVICE_TO_USE_COEFFICIENTS_ENABLE ),
  stringify( PCIE_DLLPHY_TX_PRE_CURSOR_COEFFICIENTS_REQUEST_TO_PEER_DEVICE ),
  stringify( PCIE_DLLPHY_TX_CURSOR_COEFFICIENTS_REQUEST_TO_PEER_DEVICE ),
  stringify( PCIE_DLLPHY_TX_POST_CURSOR_COEFFICIENTS_REQUEST_TO_PEER_DEVICE ),
  stringify( PCIE_DLLPHY_RX_PRESET_HINTS_REQUEST_TO_PEER_DEVICE ),
  stringify( PCIE_DLLPHY_QUIESCE_GUARANTEE ),
  stringify( PCIE_DLLPHY_PERFORM_EQUALIZATION_IN_RECOVERY_AT_GEN3_ENABLE ),
  stringify( PCIE_DLLPHY_REQUEST_FOR_EQUALIZATION_IN_RECOVERY_AT_GEN3_ENABLE ),
  stringify( PCIE_DLLPHY_AUTONOMOUS_EQUALIZATION_ENABLE ),
  stringify( PCIE_DLLPHY_PERFORM_PHASE2_PHASE3_EQUALIZATION_ENABLE ),
  stringify( PCIE_DLLPHY_GXB_EQ_LOAD_CMD ),
  stringify( PCIE_DLLPHY_GXB_RX_EQ_DC_GAIN ),
  stringify( PCIE_DLLPHY_GXB_TX_OUT_VOLTAGE ),
  stringify( PCIE_DLLPHY_GXB_TX_PREEMPHESIS_PRE_TAP ),
  stringify( PCIE_DLLPHY_GXB_TX_PREEMPHESIS_FIRST_POST_TAP ),
  stringify( PCIE_DLLPHY_GXB_TX_PREEMPHESIS_SECOND_POST_TAP ),
  stringify( PCIE_DLLPHY_CHIP_RX_EQ_AC_GAIN ),
  stringify( PCIE_DLLPHY_TX_PRE_CURSOR_COEFFICIENTS ),
  stringify( PCIE_DLLPHY_TX_CURSOR_COEFFICIENTS ),
  stringify( PCIE_DLLPHY_TX_POST_CURSOR_COEFFICIENTS ),
  stringify( PCIE_DLLPHY_TX_FS ),
  stringify( PCIE_DLLPHY_TX_LF ),
  stringify( PCIE_DLLPHY_TX_IGNORE_COEFF_RULE1_C1_FS ),
  stringify( PCIE_DLLPHY_TX_IGNORE_COEFF_RULE2_C01_FS ),
  stringify( PCIE_DLLPHY_TX_IGNORE_COEFF_RULE3_C01_LF ),
  stringify( PCIE_DLLPHY_SKIP_INTERVAL_GEN3 ),
  stringify( PCIE_DLLPHY_SKIP_SYMBOLS_NUM_GEN3 ),
  stringify( PCIE_DLLPHY_RX_LOAD_LFSR_BY_SKIP_ENABLE ),
  stringify( PCIE_DLLPHY_EXERCISER_MODE ),
  stringify( PCIE_DLLPHY_TAG_MODE ),
  stringify( PCIE_DLLPHY_PCIE_SPEC_REVISION ),
  stringify( PCIE_DLLPHY_MAX_FTS_GEN3 ),
  stringify( PCIE_DLLPHY_DELAY_COMP_QUEUE4 ),
  stringify( PCIE_DLLPHY_EQ_ENABLE_GEN3_AUTOMATIC_TRANSMITTER_DEEMPHESIS ),
  stringify( PCIE_DLLPHY_EQ_ENABLE_GEN3_AUTOMATIC_COEFFICIENT_REQUESTENABLE ),
  stringify( PCIE_DLLPHY_INITIATE_LINK_RECOVERY_ON_NO_UFC )
};

const char* EnumNames_EPCIEExerciser[] =
{
  stringify( PCIE_EXERCISER_REQUESTER_ID ),
  stringify( PCIE_EXERCISER_DATACMP_ENABLE ),
  stringify( PCIE_EXERCISER_GENERATOR_PREFIX ),
  stringify( PCIE_EXERCISER_PERF_RX_PATTERN ),
  stringify( PCIE_EXERCISER_WRONG_PAYLOAD_SIZE_BEH ),
  stringify( PCIE_EXERCISER_DATA_RATE ),
  stringify( PCIE_EXERCISER_FPGA_CONFIGURATION ),
  stringify( PCIE_EXERCISER_PERFORMANCECOUNTER_DLLPHY_ERR_LANE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_A_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_VC_RESOURCE_1_ENABLE ),
  stringify( PCIE_EXERCISER_MRIOV_PER_VH_FLOW_CONTROL ),
  stringify( PCIE_EXERCISER_MRIOV_VH1_ENABLE ),
  stringify( PCIE_EXERCISER_MRIOV_VH2_ENABLE ),
  stringify( PCIE_EXERCISER_MRIOV_VH3_ENABLE ),
  stringify( PCIE_EXERCISER_ISP_ACCESS_MODE ),
  stringify( PCIE_EXERCISER_ARI_CAPABILITY_ENABLE ),
  stringify( PCIE_EXERCISER_MRIOV_VH4_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_B_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_C_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_D_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_E_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_BVF1_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_BVF2_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_CVF1_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_CVF2_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_DVF1_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_DVF2_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_EVF1_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_DATACMP_HWCHANNEL_EVF2_COMPLETIONS_ENABLE ),
  stringify( PCIE_EXERCISER_PATTERN_TERM_0_ENABLE ),
  stringify( PCIE_EXERCISER_PATTERN_TERM_1_ENABLE ),
  stringify( PCIE_EXERCISER_PATTERN_TERM_2_ENABLE ),
  stringify( PCIE_EXERCISER_PATTERN_TERM_3_ENABLE )
};

const char* EnumNames_EPCIEBlockGen[] =
{
  stringify( PCIE_BLOCKGEN_STARTLINE ),
  stringify( PCIE_BLOCKGEN_STOPLINE ),
  stringify( PCIE_BLOCKGEN_REPEAT ),
  stringify( PCIE_BLOCKGEN_ENABLED ),
};

const char* EnumNames_EPCIEReqBehGen[] =
{
  stringify( PCIE_REQBEHGEN_STARTLINE ),
  stringify( PCIE_REQBEHGEN_STOPLINE ),
  stringify( PCIE_REQBEHGEN_OBSOLETE_02 ),
};

const char* EnumNames_EPCIECompBehGen[] =
{
  stringify( PCIE_COMPBEHGEN_STARTLINE ),
  stringify( PCIE_COMPBEHGEN_STOPLINE ),
  stringify( PCIE_COMPBEHGEN_OBSOLETE_02 ),
};

const char* EnumNames_EPCIEVC[] =
{
  stringify( PCIE_VC_TCVCMAP ),
};

const char* EnumNames_EPCIEConfigSpace[] =
{
  stringify( PCIE_CONFIGSPACE_VCC_EXTVCCOUNT ),
  stringify( PCIE_CONFIGSPACE_VCC_LPEXTVCCOUNT ),
  stringify( PCIE_CONFIGSPACE_PCIECS_DEVPORTTYPE ),
  stringify( PCIE_CONFIGSPACE_HDR_MASTER_ENABLE ),
  stringify( PCIE_CONFIGSPACE_HDR_IO_ENABLE ),
  stringify( PCIE_CONFIGSPACE_HDR_MEM_ENABLE ),
  stringify( PCIE_CONFIGSPACE_HDR_EXPROM_ENABLE ),
};

const char* EnumNames_EPCIELinkStateDirect[] =
{
  stringify( PCIE_LINKSTATEDIRECT_RECOVERY ),
  stringify( PCIE_LINKSTATEDIRECT_LOOPBACK_FROM_CONFIGURATION ),
  stringify( PCIE_LINKSTATEDIRECT_LOOPBACK_FROM_L0 ),
  stringify( PCIE_LINKSTATEDIRECT_DISABLED_FROM_CONFIGURATION ),
  stringify( PCIE_LINKSTATEDIRECT_DISABLED_FROM_L0 ),
  stringify( PCIE_LINKSTATEDIRECT_HOT_RESET ),
  stringify( PCIE_LINKSTATEDIRECT_CONFIGURATION ),
  stringify( PCIE_LINKSTATEDIRECT_IDLE ),
  stringify( PCIE_LINKSTATEDIRECT_START_LINKTRAINING ),
  stringify( PCIE_LINKSTATEDIRECT_SPEED_CHANGE ),
  stringify( PCIE_LINKSTATEDIRECT_CONFIGURATION_UPCONFIGURE ),
  stringify( PCIE_LINKSTATEDIRECT_CONFIGURATION_DOWNCONFIGURE ),
};

const char* EnumNames_EPCIERxError[] =
{
  stringify( PCIE_RXERROR_NAK_SEQUENCE_NUM ),
  stringify( PCIE_RXERROR_NAK_COUNT ),
};

const char* EnumNames_EPCIERxErrorStatus[] =
{
  stringify( PCIE_RXERRORSTATUS_NAK_COUNT ),
};

const char* EnumNames_EPCIEExerciserStatus[] =
{
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_00 ),
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_01 ),
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_02 ),
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_03 ),
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_04 ),
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_05 ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_A_INTADDR ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_A_DATA_EXPECTED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_A_DATA_REAL ),
  stringify( PCIE_EXERCISERSTATUS_OBSOLETE_09 ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_A_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_A_ERROR_COUNT ),
  /*stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_HEADER0 ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_HEADER1 ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_HEADER2 ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_HEADER3 ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_DWOFFSET ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_DATA_EXPECTED ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_DATA_REAL ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_BYTEN ),
  stringify( PCIE_EXERCISERSTATUS_DATAGENCMP_ERROR_OCCURRED ),*/
  stringify( PCIE_EXERCISERSTATUS_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_RX_POLARITY_INVERSION ),
  stringify( PCIE_EXERCISERSTATUS_REVERSED_LANES ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_A_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_B_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_C_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_D_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_E_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_BVF1_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_BVF2_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_CVF1_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_CVF2_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_DVF1_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_DVF2_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_EVF1_STATE ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_EVF2_STATE ),
  stringify( PCIE_EXERCISERSTATUS_INVALID_CLOCK ),
  stringify( PCIE_EXERCISERSTATUS_PROTERR ),
  stringify( PCIE_EXERCISERSTATUS_LTSSM_STATE ),
  stringify( PCIE_EXERCISERSTATUS_LTSSM_VERSION ),
  stringify( PCIE_EXERCISERSTATUS_LINKSTATE_DIRECT_PENDING ),
  stringify( PCIE_EXERCISERSTATUS_POWERSTATE ),
  stringify( PCIE_EXERCISERSTATUS_LINKSPEED ),
  stringify( PCIE_EXERCISERSTATUS_HARDWARE ),
  stringify( PCIE_EXERCISERSTATUS_LAST_TRAINING_CONTROL ),
  stringify( PCIE_EXERCISERSTATUS_DATARATE_RECEIVED ),
  stringify( PCIE_EXERCISERSTATUS_DATARATE_ADVERTISED ),
  stringify( PCIE_EXERCISERSTATUS_UPCONFIGURE_CAPABILITY_RECEIVED ),
  stringify( PCIE_EXERCISERSTATUS_FC_REQ_RECIEVED ),
  stringify( PCIE_EXERCISERSTATUS_VC_RESOURCE_1_INITIALIZED ),
  stringify( PCIE_EXERCISERSTATUS_MRIOV_VH1_INITIALIZED ),
  stringify( PCIE_EXERCISERSTATUS_MRIOV_VH2_INITIALIZED ),
  stringify( PCIE_EXERCISERSTATUS_MRIOV_VH3_INITIALIZED ),
  stringify( PCIE_EXERCISERSTATUS_MRIOV_NEG ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_A_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_B_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_C_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_D_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_E_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_BVF1_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_BVF2_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_CVF1_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_CVF2_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_DVF1_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_DVF2_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_EVF1_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_HWCHANNEL_EVF2_OUTSTANDING_REQUESTS ),
  stringify( PCIE_EXERCISERSTATUS_MRIOV_VH4_INITIALIZED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_B_INTADDR ),          
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_C_INTADDR ),          
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_D_INTADDR ),          
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_E_INTADDR ),          
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF1_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF2_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF1_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF2_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF1_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF2_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF1_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF2_INTADDR ),       
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_B_DATA_EXPECTED ),    
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_C_DATA_EXPECTED ),    
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_D_DATA_EXPECTED ),    
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_E_DATA_EXPECTED ),    
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF1_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF2_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF1_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF2_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF1_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF2_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF1_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF2_DATA_EXPECTED ), 
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_B_DATA_REAL ),        
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_C_DATA_REAL ),        
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_D_DATA_REAL ),        
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_E_DATA_REAL ),        
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF1_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF2_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF1_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF2_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF1_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF2_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF1_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF2_DATA_REAL ),     
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_B_ERROR_OCCURRED ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_C_ERROR_OCCURRED ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_D_ERROR_OCCURRED ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_E_ERROR_OCCURRED ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF1_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF2_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF1_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF2_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF1_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF2_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF1_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF2_ERROR_OCCURRED ),
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_B_ERROR_COUNT ),      
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_C_ERROR_COUNT ),      
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_D_ERROR_COUNT ),      
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_E_ERROR_COUNT ),      
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF1_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_BVF2_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF1_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_CVF2_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF1_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_DVF2_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF1_ERROR_COUNT ),   
  stringify( PCIE_EXERCISERSTATUS_DATAMEMCMP_HWCHANNEL_EVF2_ERROR_COUNT ),
  stringify( PCIE_EXERCISERSTATUS_RX_PRESET_HINT ),
  stringify( PCIE_EXERCISERSTATUS_DUT_FS ),
  stringify( PCIE_EXERCISERSTATUS_DUT_LF )
};

const char* EnumNames_EPCIEPattern[] =
{
  stringify( PCIE_PATTERN_LEN ),
  stringify( PCIE_PATTERN_RSVD023 ),
  stringify( PCIE_PATTERN_ATTR ),
  stringify( PCIE_PATTERN_EP ),
  stringify( PCIE_PATTERN_TD ),
  stringify( PCIE_PATTERN_RSVD013 ),
  stringify( PCIE_PATTERN_TC ),
  stringify( PCIE_PATTERN_RSVD017 ),
  stringify( PCIE_PATTERN_TYPE ),
  stringify( PCIE_PATTERN_FMT ),
  stringify( PCIE_PATTERN_RSVD007 ),
  stringify( PCIE_PATTERN_1STDWBE ),
  stringify( PCIE_PATTERN_LASTDWBE ),
  stringify( PCIE_PATTERN_TAG ),
  stringify( PCIE_PATTERN_REQID ),
  stringify( PCIE_PATTERN_CFG_RSVD111 ),
  stringify( PCIE_PATTERN_CFG_REGNUM ),
  stringify( PCIE_PATTERN_CFG_EXTREGNUM ),
  stringify( PCIE_PATTERN_CFG_RSVD107 ),
  stringify( PCIE_PATTERN_CFG_FUNCNUM ),
  stringify( PCIE_PATTERN_CFG_DEVNUM ),
  stringify( PCIE_PATTERN_CFG_BUSNUM ),
  stringify( PCIE_PATTERN_MEM64_ADDRHI ),
  stringify( PCIE_PATTERN_MEM64_ADDRLO ),
  stringify( PCIE_PATTERN_MEM64_RSVD151 ),
  stringify( PCIE_PATTERN_MEM32_ADDR ),
  stringify( PCIE_PATTERN_MEM32_RSVD111 ),
  stringify( PCIE_PATTERN_MCODE ),
  stringify( PCIE_PATTERN_IO_ADDR ),
  stringify( PCIE_PATTERN_IO_RSVD111 ),
  stringify( PCIE_PATTERN_MSGAS_RSVD047 ),
  stringify( PCIE_PATTERN_MSGAS_RSVD087 ),
  stringify( PCIE_PATTERN_MSGAS_RSVD127 ),
  stringify( PCIE_PATTERN_MSG_BYTES08_11 ),
  stringify( PCIE_PATTERN_MSG_BYTES12_15 ),
  stringify( PCIE_PATTERN_MSGASD_RSVD047 ),
  stringify( PCIE_PATTERN_MSGASD_RSVD087 ),
  stringify( PCIE_PATTERN_MSGASD_RSVD127 ),
  stringify( PCIE_PATTERN_COMP_REQID ),
  stringify( PCIE_PATTERN_COMP_COMPLID ),
  stringify( PCIE_PATTERN_COMP_STATUS ),
  stringify( PCIE_PATTERN_COMP_BYTECOUNT ),
  stringify( PCIE_PATTERN_COMP_BCM ),
  stringify( PCIE_PATTERN_COMP_TAG ),
  stringify( PCIE_PATTERN_COMP_RSVD117 ),
  stringify( PCIE_PATTERN_COMP_LOWERADDR ),
  stringify( PCIE_PATTERN_HEADER_DW0 ),
  stringify( PCIE_PATTERN_HEADER_DW1 ),
  stringify( PCIE_PATTERN_HEADER_DW2 ),
  stringify( PCIE_PATTERN_HEADER_DW3 ),
  stringify( PCIE_PATTERN_PAYLOAD_DW0 ),
  stringify( PCIE_PATTERN_PAYLOAD_DW1 ),
  stringify( PCIE_PATTERN_PAYLOAD_DW2 ),
  stringify( PCIE_PATTERN_PAYLOAD_DW3 ),
  stringify( PCIE_PATTERN_MRIOV_PREFIX_HEADER ),
  stringify( PCIE_PATTERN_MRIOV_PREFIX_PREFIXTAG ),
  stringify( PCIE_PATTERN_MRIOV_PREFIX_GLOBALKEY ),
  stringify( PCIE_PATTERN_MRIOV_PREFIX_RSVD023 ),
  stringify( PCIE_PATTERN_MRIOV_PREFIX_VLNUM ),
  stringify( PCIE_PATTERN_MRIOV_PREFIX_VHNUM ),
};

const char* EnumNames_EPCIEPerformanceCounterStatus[] =
{
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLPHY_CODING_ERR ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLPHY_DISPARITY_ERR ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLPHY_128B_130B_ERR ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_SUCCESSFUL_LINK_TRAININGS ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLP_ACK ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLP_NAK ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_INTERVAL_LEN ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLP_TX_NAK ),
};

const char* EnumNames_EPCIEPerformanceCounterVCStatus[] =
{
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DLLP_FC ),
};

const char* EnumNames_EPCIEPerformanceCounterFunctionStatus[] =
{
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_TLP_NUM ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_DW_NUM ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_TX_TLP_NUM ),
  stringify( PCIE_PERFORMANCECOUNTERSTATUS_TX_DW_NUM ),
};

const char* EnumNames_EPCIETriggerOut[] =
{
  stringify( PCIE_TRIGGEROUT_PROTERR ),
  stringify( PCIE_TRIGGEROUT_PATTERN ),
  stringify( PCIE_TRIGGEROUT_CMPERR ),
  stringify( PCIE_TRIGGEROUT_GOING_OUT_OF_L0 ),
};

const char* EnumNames_EPCIEDllpStatus[] =
{
  stringify( PCIE_DLLPSTATUS_DATASENT ),
  stringify( PCIE_DLLPSTATUS_WRONGCRC_DONE ),
  stringify( PCIE_DLLPSTATUS_LASTSEQREQUESTED ),
  stringify( PCIE_DLLPSTATUS_LASTSEQRECEIVED ),
};

const char* EnumNames_EPCIEDllp[] =
{
  stringify( PCIE_DLLPPROPERTY_WRONGCRCPATTERN ),
  stringify( PCIE_DLLPPROPERTY_WRONGCRCMASK ),
};

const char* EnumNames_EPCIEDllpControl[] =
{
  stringify( PCIE_DLLPCONTROL_WRONGCRC ),
};

const char* EnumNames_EPCIEScratchPadRegister[] =
{
  stringify( PCIE_SCRATCH_PAD_REGISTER0 ),
  stringify( PCIE_SCRATCH_PAD_REGISTER1 ),
  stringify( PCIE_SCRATCH_PAD_REGISTER2 ),
  stringify( PCIE_SCRATCH_PAD_REGISTER3 ),
};

#pragma endregion

#pragma region Constructor

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();

  Write( m_strFunctionName );
  Write( "(" );
  Write( ")" );
  WriteLineBreak();
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p, bool bDoNotLogFnName_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();

  if( !bDoNotLogFnName_p )
  {
    Write( m_strFunctionName );
    Write( "(" );
    Write( ")" );
    WriteLineBreak();
  }
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
                                  ParamTypes paramType1_p, int nValue1_p)
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();
  Write( m_strFunctionName );
  Write( "( " );
  PrintParam( paramType1_p, nValue1_p );
  Write( " )" );
  WriteLineBreak();
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
                                  ParamTypes paramType1_p, int nValue1_p,
                                  ParamTypes paramType2_p, int nValue2_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();
  Write( m_strFunctionName );
  Write( "( " );
  PrintParam( paramType1_p, nValue1_p ); Write( ", " );
  PrintParam( paramType2_p, nValue2_p );
  Write( " )" );
  WriteLineBreak();
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
                                  ParamTypes paramType1_p, int nValue1_p,
                                  ParamTypes paramType2_p, int nValue2_p,
                                  ParamTypes paramType3_p, int nValue3_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();
  Write( m_strFunctionName );
  Write( "( " );
  PrintParam( paramType1_p, nValue1_p ); Write( ", " );
  PrintParam( paramType2_p, nValue2_p ); Write( ", " );
  PrintParam( paramType3_p, nValue3_p );
  Write( " )" );
  WriteLineBreak();
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
                                  ParamTypes paramType1_p, int nValue1_p,
                                  ParamTypes paramType2_p, int nValue2_p,
                                  ParamTypes paramType3_p, int nValue3_p,
                                  ParamTypes paramType4_p, int nValue4_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();
  Write( m_strFunctionName );
  Write( "( " );
  PrintParam( paramType1_p, nValue1_p ); Write( ", " );
  PrintParam( paramType2_p, nValue2_p ); Write( ", " );
  PrintParam( paramType3_p, nValue3_p ); Write( ", " );
  PrintParam( paramType4_p, nValue4_p );
  Write( " )" );
  WriteLineBreak();
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
                                  ParamTypes paramType1_p, int nValue1_p,
                                  ParamTypes paramType2_p, int nValue2_p,
                                  ParamTypes paramType3_p, int nValue3_p,
                                  ParamTypes paramType4_p, int nValue4_p,
                                  ParamTypes paramType5_p, int nValue5_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();
  Write( m_strFunctionName );
  Write( "( " );
  PrintParam( paramType1_p, nValue1_p ); Write( ", " );
  PrintParam( paramType2_p, nValue2_p ); Write( ", " );
  PrintParam( paramType3_p, nValue3_p ); Write( ", " );
  PrintParam( paramType4_p, nValue4_p ); Write( ", " );
  PrintParam( paramType5_p, nValue5_p );
  Write( " )" );
  WriteLineBreak();
}

CFunctionLogger::CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
                                  ParamTypes paramType1_p, int nValue1_p,
                                  ParamTypes paramType2_p, int nValue2_p,
                                  ParamTypes paramType3_p, int nValue3_p,
                                  ParamTypes paramType4_p, int nValue4_p,
                                  ParamTypes paramType5_p, int nValue5_p,
                                  ParamTypes paramType6_p, int nValue6_p )
{
  m_pDebugLogger = pDebugLogger_p;
  strcpy( m_strFunctionName, strFunctionName_p );

  IncrementIndent();
  Write( m_strFunctionName );
  Write( "( " );
  PrintParam( paramType1_p, nValue1_p ); Write( ", " );
  PrintParam( paramType2_p, nValue2_p ); Write( ", " );
  PrintParam( paramType3_p, nValue3_p ); Write( ", " );
  PrintParam( paramType4_p, nValue4_p ); Write( ", " );
  PrintParam( paramType5_p, nValue5_p ); Write( ", " );
  PrintParam( paramType6_p, nValue6_p );
  Write( " )" );
  WriteLineBreak();
}

#pragma endregion

#pragma region Destructor

CFunctionLogger::~CFunctionLogger()
{
  DecrementIndent();
}

#pragma endregion

#pragma region Public Methods

void CFunctionLogger::WriteDecUInt( unsigned int uVal_p )
{
  m_pDebugLogger->WriteDecUInt( uVal_p );
}

void CFunctionLogger::WriteHexUInt( unsigned int uVal_p )
{
  m_pDebugLogger->WriteHexUInt( uVal_p );
}

void CFunctionLogger::WriteLineBreak()
{
  m_pDebugLogger->WriteLineBreak();
}

void CFunctionLogger::Write( const char* strMessage_p )
{
  m_pDebugLogger->Write( strMessage_p );
}

void CFunctionLogger::WriteLine( const char* strMessage_p )
{
  m_pDebugLogger->WriteLine( strMessage_p );
}

#pragma endregion

#pragma region Private Methods

void CFunctionLogger::IncrementIndent()
{
  m_pDebugLogger->IncrementIndent();
}

void CFunctionLogger::DecrementIndent()
{
  m_pDebugLogger->DecrementIndent();
}

void CFunctionLogger::PrintParam( ParamTypes paramType, int nValue_p )
{
  switch( paramType )
  {
  case ParamType_EPCIEHostControllerVersion:
    Write( EnumNames_EPCIEHostControllerVersion[ nValue_p ] );
    break;
  case ParamType_EPCIEDecProp:
    Write( EnumNames_EPCIEDecProp[ nValue_p ] );
    break;
  case ParamType_EPCIECompQueue:
    Write( EnumNames_EPCIECompQueue[ nValue_p ] );
    break;
  case ParamType_EPCIEDec:
    Write( EnumNames_EPCIEDec[ nValue_p ] );
    break;
  case ParamType_EPCIESiStatus:
    Write( EnumNames_EPCIESiStatus[ nValue_p ] );
    break;
  case ParamType_EPCIESi:
    Write( EnumNames_EPCIESi[ nValue_p ] );
    break;
  case ParamType_EPCIEHwChannelFunction:
    Write( EnumNames_EPCIEHwChannelFunction[ nValue_p ] );
    break;
  case ParamType_EPCIEVCResourceId:
    Write( EnumNames_EPCIEVCResourceId[ nValue_p ] );
    break;
  case ParamType_EPCIEVCResourceProp:
    Write( EnumNames_EPCIEVCResourceProp[ nValue_p ] );
    break;
  case ParamType_EPCIEVCResourceStatusProp:
    Write( EnumNames_EPCIEVCResourceStatusProp[ nValue_p ] );
    break;
  case ParamType_EPCIEProtRule:
    Write( EnumNames_EPCIEProtRule[ nValue_p ] );
    break;
  case ParamType_EPCIEProtRuleVC:
    Write( EnumNames_EPCIEProtRuleVC[ nValue_p ] );
    break;
  case ParamType_EPCIEProtRuleFunction:
    Write( EnumNames_EPCIEProtRuleFunction[ nValue_p ] );
    break;
  case ParamType_EPCIEBlock:
    Write( EnumNames_EPCIEBlock[ nValue_p ] );
    break;
  case ParamType_EPCIEReqBeh:
    Write( EnumNames_EPCIEReqBeh[ nValue_p ] );
    break;
  case ParamType_EPCIECompBeh:
    Write( EnumNames_EPCIECompBeh[ nValue_p ] );
    break;
  case ParamType_EPCIEDllPhy:
    Write( EnumNames_EPCIEDllPhy[ nValue_p ] );
    break;
  case ParamType_EPCIEExerciser:
    Write( EnumNames_EPCIEExerciser[ nValue_p ] );
    break;
  case ParamType_EPCIEBlockGen:
    Write( EnumNames_EPCIEBlockGen[ nValue_p ] );
    break;
  case ParamType_EPCIEReqBehGen:
    Write( EnumNames_EPCIEReqBehGen[ nValue_p ] );
    break;
  case ParamType_EPCIECompBehGen:
    Write( EnumNames_EPCIECompBehGen[ nValue_p ] );
    break;
  case ParamType_EPCIEVC:
    Write( EnumNames_EPCIEVC[ nValue_p ] );
    break;
  case ParamType_EPCIEConfigSpace:
    Write( EnumNames_EPCIEConfigSpace[ nValue_p ] );
    break;
  case ParamType_EPCIELinkStateDirect:
    Write( EnumNames_EPCIELinkStateDirect[ nValue_p ] );
    break;
  case ParamType_EPCIERxError:
    Write( EnumNames_EPCIERxError[ nValue_p ] );
    break;
  case ParamType_EPCIERxErrorStatus:
    Write( EnumNames_EPCIERxErrorStatus[ nValue_p ] );
    break;
  case ParamType_EPCIEExerciserStatus:
    Write( EnumNames_EPCIEExerciserStatus[ nValue_p ] );
    break;
  case ParamType_EPCIEPattern:
    Write( EnumNames_EPCIEPattern[ nValue_p ] );
    break;
  case ParamType_EPCIEPerformanceCounterStatus:
    Write( EnumNames_EPCIEPerformanceCounterStatus[ nValue_p ] );
    break;
  case ParamType_EPCIEPerformanceCounterVCStatus:
    Write( EnumNames_EPCIEPerformanceCounterVCStatus[ nValue_p ] );
    break;
  case ParamType_EPCIEPerformanceCounterFunctionStatus:
    Write( EnumNames_EPCIEPerformanceCounterFunctionStatus[ nValue_p ] );
    break;
  case ParamType_EPCIEDllpStatus:
    Write( EnumNames_EPCIEDllpStatus[ nValue_p ] );
    break;
  case ParamType_EPCIEDllp:
    Write( EnumNames_EPCIEDllp[ nValue_p ] );
    break;
  case ParamType_EPCIEDllpControl:
    Write( EnumNames_EPCIEDllpControl[ nValue_p ] );
    break;
  case ParamType_EPCIEScratchPadRegister:
    Write( EnumNames_EPCIEScratchPadRegister[ nValue_p ] );
    break;
  case ParamType_EPCIETriggerOut:
    if( nValue_p == PCIE_TRIGGEROUT_GOING_OUT_OF_L0 )
      Write( EnumNames_EPCIETriggerOut[ 9 ] );
    else
      Write( EnumNames_EPCIETriggerOut[ nValue_p ] );
    break;
  case ParamType_bool:
    if( nValue_p == 0 )
      Write( "false" );
    else
      Write( "true" );
    Write( "{" );
    WriteDecUInt( nValue_p );
    Write( "}" );
    break;
  case ParamType_UInt8:
  case ParamType_UInt16:
  case ParamType_UInt32:
  case ParamType_AgtPortHandleT:
  case ParamType_AgtValueT:
  case ParamType_AgtSizeT:
  default:
    WriteHexUInt( nValue_p );
    Write( "{" );
    WriteDecUInt( nValue_p );
    Write( "}" );
    break;
  }
}

#pragma endregion